<?php
// Güvenlik kontrolü
if (!defined('ABSPATH')) {
    exit;
}

function auto_republisher_settings_page() {
    // Ayarları kaydet
    if (isset($_POST['auto_republisher_save'])) {
        check_admin_referer('auto_republisher_settings');
        
        // Zamanlama ayarları
        $interval_type = sanitize_text_field($_POST['interval_type']);
        $interval_value = absint($_POST['interval_value']);
        $interval_random = isset($_POST['interval_random']) ? 1 : 0;
        
        // Post statüsü
        $post_statuses = isset($_POST['post_statuses']) ? array_map('sanitize_text_field', $_POST['post_statuses']) : [];
        
        // Kategoriler
        $categories = isset($_POST['categories']) ? array_map('absint', $_POST['categories']) : [];
        
        // Post sayısı
        $post_count_min = absint($_POST['post_count_min']);
        $post_count_max = absint($_POST['post_count_max']);
        
        // Ayarları kaydet
        update_option('auto_republisher_interval_type', $interval_type);
        update_option('auto_republisher_interval_value', $interval_value);
        update_option('auto_republisher_interval_random', $interval_random);
        update_option('auto_republisher_post_statuses', $post_statuses);
        update_option('auto_republisher_categories', $categories);
        update_option('auto_republisher_post_count_min', $post_count_min);
        update_option('auto_republisher_post_count_max', $post_count_max);
        
        auto_republisher_log('Ayarlar kaydedildi.');
        echo '<div class="updated"><p>' . __('Settings saved.', 'auto-republisher') . '</p></div>';
    }

    // Ayarları al
    $interval_type = get_option('auto_republisher_interval_type', 'hours');
    $interval_value = get_option('auto_republisher_interval_value', 1);
    $interval_random = get_option('auto_republisher_interval_random', 0);
    $post_statuses = get_option('auto_republisher_post_statuses', []);
    $categories = get_option('auto_republisher_categories', []);
    $post_count_min = get_option('auto_republisher_post_count_min', 1);
    $post_count_max = get_option('auto_republisher_post_count_max', 10);

    ?>
    <div class="wrap">
        <h1><?php _e('Auto Republisher Settings', 'auto-republisher'); ?></h1>
        <form method="post" action="">
            <?php wp_nonce_field('auto_republisher_settings'); ?>
            
            <h2><?php _e('Scheduling Settings', 'auto-republisher'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><label for="interval_value"><?php _e('Interval Value', 'auto-republisher'); ?></label></th>
                    <td>
                        <input type="number" name="interval_value" id="interval_value" value="<?php echo esc_attr($interval_value); ?>" min="1" />
                    </td>
                </tr>
                <tr>
                    <th><label for="interval_type"><?php _e('Interval Type', 'auto-republisher'); ?></label></th>
                    <td>
                        <select name="interval_type" id="interval_type">
                            <option value="minutes" <?php selected($interval_type, 'minutes'); ?>><?php _e('Minutes', 'auto-republisher'); ?></option>
                            <option value="hours" <?php selected($interval_type, 'hours'); ?>><?php _e('Hours', 'auto-republisher'); ?></option>
                            <option value="days" <?php selected($interval_type, 'days'); ?>><?php _e('Days', 'auto-republisher'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th><label for="interval_random"><?php _e('Random Interval', 'auto-republisher'); ?></label></th>
                    <td>
                        <input type="checkbox" name="interval_random" id="interval_random" value="1" <?php checked($interval_random, 1); ?> />
                        <label for="interval_random"><?php _e('Run at random intervals within the selected range', 'auto-republisher'); ?></label>
                    </td>
                </tr>
            </table>

            <h2><?php _e('Post Status Selection', 'auto-republisher'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><?php _e('Select Post Statuses', 'auto-republisher'); ?></th>
                    <td>
                        <label><input type="checkbox" name="post_statuses[]" value="draft" <?php echo in_array('draft', $post_statuses) ? 'checked' : ''; ?> /> <?php _e('Draft', 'auto-republisher'); ?></label><br />
                        <label><input type="checkbox" name="post_statuses[]" value="pending" <?php echo in_array('pending', $post_statuses) ? 'checked' : ''; ?> /> <?php _e('Pending', 'auto-republisher'); ?></label><br />
                        <label><input type="checkbox" name="post_statuses[]" value="publish" <?php echo in_array('publish', $post_statuses) ? 'checked' : ''; ?> /> <?php _e('Published', 'auto-republisher'); ?></label>
                    </td>
                </tr>
            </table>

            <h2><?php _e('Category Selection', 'auto-republisher'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><?php _e('Select Categories', 'auto-republisher'); ?></th>
                    <td>
                        <?php
                        $all_categories = get_categories(['hide_empty' => false]);
                        foreach ($all_categories as $category) {
                            ?>
                            <label><input type="checkbox" name="categories[]" value="<?php echo esc_attr($category->term_id); ?>" <?php echo in_array($category->term_id, $categories) ? 'checked' : ''; ?> /> <?php echo esc_html($category->name); ?></label><br />
                            <?php
                        }
                        ?>
                    </td>
                </tr>
            </table>

            <h2><?php _e('Post Count Settings', 'auto-republisher'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><label for="post_count_min"><?php _e('Minimum Posts to Republish', 'auto-republisher'); ?></label></th>
                    <td>
                        <input type="number" name="post_count_min" id="post_count_min" value="<?php echo esc_attr($post_count_min); ?>" min="1" />
                    </td>
                </tr>
                <tr>
                    <th><label for="post_count_max"><?php _e('Maximum Posts to Republish', 'auto-republisher'); ?></label></th>
                    <td>
                        <input type="number" name="post_count_max" id="post_count_max" value="<?php echo esc_attr($post_count_max); ?>" min="1" />
                    </td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" name="auto_republisher_save" class="button-primary" value="<?php _e('Save and Run', 'auto-republisher'); ?>" />
            </p>
        </form>

        <h2><?php _e('Log', 'auto-republisher'); ?></h2>
        <textarea readonly rows="10" cols="100"><?php echo esc_textarea(auto_republisher_get_log()); ?></textarea>
    </div>
    <?php
}