<?php
// Güvenlik kontrolü
if (!defined('ABSPATH')) {
    exit;
}

add_action('auto_republisher_cron', 'auto_republisher_run');

function auto_republisher_run() {
    // Ayarları al
    $interval_type = get_option('auto_republisher_interval_type', 'hours');
    $interval_value = get_option('auto_republisher_interval_value', 1);
    $interval_random = get_option('auto_republisher_interval_random', 0);
    $post_statuses = get_option('auto_republisher_post_statuses', []);
    $categories = get_option('auto_republisher_categories', []);
    $post_count_min = get_option('auto_republisher_post_count_min', 1);
    $post_count_max = get_option('auto_republisher_post_count_max', 10);

    // Ayarların geçerliliğini kontrol et
    if (empty($post_statuses) || empty($categories)) {
        auto_republisher_log('Hata: Post statüsü veya kategori seçilmedi.');
        return;
    }

    // Rastgele post sayısı belirle
    $post_count = rand($post_count_min, $post_count_max);

    // Postları sorgula
    $args = [
        'post_type' => 'post',
        'post_status' => $post_statuses,
        'cat' => implode(',', $categories),
        'posts_per_page' => $post_count,
        'orderby' => 'rand',
    ];

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $count = 0;
        while ($query->have_posts()) {
            $query->the_post();
            $post_id = get_the_ID();
            
            // Postu yeniden yayınla (yayın tarihi şimdiye güncellenir)
            wp_update_post([
                'ID' => $post_id,
                'post_date' => current_time('mysql'),
                'post_date_gmt' => current_time('mysql', 1),
                'post_status' => 'publish',
            ]);
            $count++;
        }
        auto_republisher_log(sprintf(__('%d post(s) republished.', 'auto-republisher'), $count));
    } else {
        auto_republisher_log('Yeniden yayınlanacak post bulunamadı.');
    }

    wp_reset_postdata();

    // Yeni bir cron olayı zamanla
    if ($interval_random) {
        $interval_value = rand(1, $interval_value);
    }

    $interval_in_seconds = $interval_value * ($interval_type === 'minutes' ? 60 : ($interval_type === 'hours' ? 3600 : 86400));
    wp_schedule_single_event(time() + $interval_in_seconds, 'auto_republisher_cron');
    auto_republisher_log(sprintf(__('Next run scheduled in %d %s.', 'auto-republisher'), $interval_value, $interval_type));
}