<?php
// Güvenlik kontrolü
if (!defined('ABSPATH')) {
    exit;
}

function auto_republisher_create_log_directory() {
    $upload_dir = wp_upload_dir();
    $log_dir = $upload_dir['basedir'] . '/auto-republisher-logs';
    
    if (!file_exists($log_dir)) {
        wp_mkdir_p($log_dir);
    }
}

function auto_republisher_log($message) {
    $upload_dir = wp_upload_dir();
    $log_file = $upload_dir['basedir'] . '/auto-republisher-logs/log.txt';
    
    $time = current_time('mysql');
    $log_entry = "[$time] $message\n";
    
    file_put_contents($log_file, $log_entry, FILE_APPEND | LOCK_EX);
}

function auto_republisher_get_log() {
    $upload_dir = wp_upload_dir();
    $log_file = $upload_dir['basedir'] . '/auto-republisher-logs/log.txt';
    
    if (file_exists($log_file)) {
        return file_get_contents($log_file);
    }
    
    return '';
}