<?php
/*
Plugin Name: Auto Republisher
Plugin URI: https://digitallicense.net/auto-republisher-free-wordpress-plugin
Description: Automatically republish posts based on user-defined settings with scheduling, status, category, and logging features.
Version: 1.0.0
Author: Local Seo Services
Author URI: https://seoz.us
License: GPL2
Text Domain: auto-republisher
*/

// Güvenlik kontrolü
if (!defined('ABSPATH')) {
    exit;
}

// Gerekli dosyaları yükle
require_once plugin_dir_path(__FILE__) . 'includes/settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/scheduler.php';
require_once plugin_dir_path(__FILE__) . 'includes/logger.php';

// Eklenti aktivasyon ve deaktivasyon işlemleri
register_activation_hook(__FILE__, 'auto_republisher_activate');
register_deactivation_hook(__FILE__, 'auto_republisher_deactivate');

function auto_republisher_activate() {
    // WP-Cron olayını başlat
    if (!wp_next_scheduled('auto_republisher_cron')) {
        wp_schedule_event(time(), 'hourly', 'auto_republisher_cron');
    }
    // Log klasörünü oluştur
    auto_republisher_create_log_directory();
    // Aktivasyon logu
    auto_republisher_log('Eklenti aktifleştirildi.');
}

function auto_republisher_deactivate() {
    // WP-Cron olayını temizle
    wp_clear_scheduled_hook('auto_republisher_cron');
    auto_republisher_log('Eklenti deaktifleştirildi.');
}

// Eklenti ayar menüsünü ekle
add_action('admin_menu', 'auto_republisher_add_menu');

function auto_republisher_add_menu() {
    add_options_page(
        __('Auto Republisher Settings', 'auto-republisher'),
        __('Auto Republisher', 'auto-republisher'),
        'manage_options',
        'auto-republisher',
        'auto_republisher_settings_page'
    );
}

// Text domain yüklemesi
add_action('plugins_loaded', 'auto_republisher_load_textdomain');
function auto_republisher_load_textdomain() {
    load_plugin_textdomain('auto-republisher', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}